/*					 		  AD9834 DDS Control Routines for the FM Stereo Encoder Project	     */
/*                            By George A. Adamidis                                              */
/*                            Ver 1.0 - Jan 26, 2013                                             */ 
/*************************************************************************************************/
// All rights are reserved 

// MPLAB V8.5
// Mcc18 V3.1
// Loaded on a PIC18F1220 microcontroler
// All timing routines have been written for 4MHz master clock.
//--------------------------------------------------------------------------------

#include "definitions.h"        /* pin and other definitions        */
#include <p18f1220.h>        	// for pic18f1220 

//functions
void Send_frame(unsigned char* pframex, unsigned char chip); // Transmits the 16-bit *pframex to the AD9834 chips, through the serial interface (FDATA, FSYNC, SCLK)
void SDATA(unsigned char dbit,unsigned char chip);	 		 // Sets FDATA line to 0 or 1 if dbit=0 or 1 respectively
void FSYNC(unsigned char sync,unsigned char chip);  		 // Sets FSYNC line to 0 or 1 if sync=0 or 1 respectively
void SCLK (unsigned char clk,unsigned char chip);   		 // Sets SCLK line to 0 or 1 if clk=0 or 1 respectively 
// Sends data to U3 or U4 if chip=0, or 1 respectively 



//-------------------------------------------------------------------
// Transmits the 16-bit *pframex to the AD9834 chips, through the serial interface (FDATA, FSYNC, SCLK).
void Send_frame(unsigned char* pframex, unsigned char chip)
{
	int u;

	SCLK(1, chip);
	FSYNC(0, chip);

	//Transmits the 16-bit frame[16] to the microwire bus 
	for (u=15; u>-1; u--)
		{
			SDATA(*pframex, chip);
			pframex--;
			SCLK(0, chip);
        	SCLK(1, chip);
		}
	FSYNC(1, chip);

return;
}

//-------------------------------------------------------------------
// Sets FDATA line to 0 or 1 if dbit=0 or 1 respectively			
void SDATA(unsigned char dbit,unsigned char chip)	 
{
	
switch (chip)
	{
		case 0:
			data_pinU3=dbit;
		break;
	
		case 1:
			data_pinU4=dbit;
		break;
	}

	return;
}

//-------------------------------------------------------------------
// Sets FSYNC line to 0 or 1 if sync=0 or 1 respectively
void FSYNC(unsigned char sync,unsigned char chip)  
{
	
	switch (chip)
		{
			case 0:
				sync_pinU3=sync;
			break;
		
			case 1:
				sync_pinU4=sync;
			break;
		}
	

	return;
}

//-------------------------------------------------------------------
// Sets SCLK line to 0 or 1 if clk=0 or 1 respectively
void SCLK (unsigned char clk,unsigned char chip)    
{
	
	switch (chip)
		{
			case 0:
				clk_pinU3=clk;
			break;
		
			case 1:
				clk_pinU4=clk;
			break;
		}

	return;
}